﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            HP 8496A (Opt 001): (1 year) VER /9640A,N5531S
DATE:                  2016-06-27 16:49:36
AUTHOR:                Fluke
REVISION:              $Revision: 16361 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       25
NUMBER OF LINES:       356
CONFIGURATION:         Agilent PSA (6.7 GHz,123,233)
CONFIGURATION:         Fluke 9640A
CONFIGURATION:         Fluke 9640A-50
=============================================================================
#
#  Procedure Author:
#        DAC, DFM
#
#  Source(s):
#        Agilent Technologies 8496A/B, 8495A/B, and 8496A/B Attenuators,
#        Operating and Service Manual, Agilent Part No. 08494-90008, 4/2002
#
#        U.S.A.F. T.O.33K4-4-64-1, CALIBRATION PROCEDURE FOR VARIABLE
#        COAXIAL ATTENUATORS, 30 DECEMBER 2001, CHANGE 6 - 30 NOVEMBER 2004
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        2 ea., precision Type "N" 10 dB attenuators
#        1 ea., precision Type "N" barrel connector
#        2 ea., precision Type "N" patch cables
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  ASK-   R   Q N              P                                     V

  1.002  IF           NOT(VERSIONCHECK("8.0"))
  1.003  END
  1.004  ENDIF

  1.005  CALL         Sub Display Copyright
  1.006  CALL         Sub Select Verification Method (No NTHROW)
  1.007  CALL         Sub Select Failed Test Mode
  1.008  CALL         Sub HP 849x (Opt 001) Equipment Requirements

  1.009  OPBR         -z Do you wish to calibrate the spectrum analyzer?

  1.010  IF           MEM1
  1.011  HEAD         SPECTRUM ANALYZER CALIBRATION
  1.012  TARGET
  1.013  PSA          Cal
  1.014  ENDIF

  1.015  CALL         Sub HP 849x (Opt 001) Test Setup /9640,N5531

  1.016  RSLT         =
  1.017  HEAD         {INSERTION LOSS}
  1.018  RSLT         =
  1.019  HEAD         -2{1500 MHz}
  1.020  TARGET       -p
  1.021  DISP         Connect the open ends (male) of the two 10 dB
  1.021  DISP         attenuators to one another via a precision
  1.021  DISP         Type N (f)-(f) adapter.
  1.022  9640         +Freq = 1500 MHz; Level = 5 dBm; OutputImp = 50 Ohms
# Measure input frequency.
  1.023  N5531        +Freq = 1500 MHz; Power = 5 dBm
  1.024  MATH         FreqMHz = MEM
# Set relative Tuned RF Level reference.
  1.025  N5531        +Level = -15 dBm; Freq = [V FreqMHz] MHz; SetRef
  1.026  9640         Standby

  1.027  DISP         Disconnect the two 10 dB attenuators from the precision
  1.027  DISP         Type N (f) - (f) adapter.
  1.027  DISP
  1.027  DISP         Connect the two 10 dB attenuators to the UUT
  1.027  DISP         input/output ports, respectively.
  1.028  DISP         Set the UUT to 0 dB.
  1.029  9640         +Freq = 1500 MHz; Level = 5 dBm; OutputImp = 50 Ohms
  1.030  TARGET       -m
  1.031  N5531        +RelLevel = 0.00 dB; Freq = [V FreqMHz] MHz; Read
# Maximum Residual Attenuation is 0.6 dB + 0.09 dB/GHz.
  1.032  MATH         L[1] = 0.6 + (0.09 / 1.5)
  1.033  MEMC         0.00dB         L1U           1500MHz

  2.001  9640         Standby

  2.002  RSLT         =
  2.003  HEAD         -2{4000 MHz}
  2.004  TARGET       -p
  2.005  DISP         Disconnect the two 10 dB attenuators from the UUT.
  2.005  DISP
  2.005  DISP         Connect the open ends of the two 10 dB attenuators to
  2.005  DISP         one another via a precision Type N (f)-(f) adapter.
  2.006  9640         +Freq = 4000 MHz; Level = 5 dBm; OutputImp = 50 Ohms
  2.007  N5531        +Freq = 4000 MHz; Power = 5 dBm
  2.008  MATH         FreqMHz = MEM
  2.009  N5531        +Level = -15 dBm; Freq = [V FreqMHz] MHz; SetRef
  2.010  9640         Standby

  2.011  DISP         Disconnect the two 10 dB attenuators from the precision
  2.011  DISP         Type N (f) - (f) adapter.
  2.011  DISP
  2.011  DISP         Connect the two 10 dB attenuators to the UUT
  2.011  DISP         input/output ports, respectively.
  2.012  9640         +Freq = 4000 MHz; Level = 5 dBm; OutputImp = 50 Ohms
  2.013  TARGET       -m
  2.014  N5531        +RelLevel = 0.00 dB; Freq = [V FreqMHz] MHz; Read
# Maximum Residual Attenuation is 0.6 dB + 0.09 dB/GHz.
  2.015  MATH         L[1] = 0.6 + (0.09 / 4.0)
  2.016  MEMC         0.00dB         L1U           4000MHz

  3.001  HEAD         -2
  3.002  9640         Standby

  3.003  RSLT         =
  3.004  HEAD         {ATTENUATION}
  3.005  RSLT         =
  3.006  RSLT         = 1500 MHz
  3.007  HEAD         -2 SET 0 dB REFERENCE @ 1500 MHz
  3.008  TARGET       -p
  3.009  DISP         Set the UUT to 0 dB.
  3.010  9640         +Freq = 1500 MHz; Level = 5 dBm; OutputImp = 50 Ohms
  3.011  N5531        Power = 5 dBm; InputAttenuation = 10 dB
  3.011  N5531        +Freq = 1500 MHz
  3.012  MATH         FreqMHz = MEM
  3.013  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
  3.013  N5531        +Level = -15 dBm; SetRef

  3.014  HEAD         -2 10 dB @ 1500 MHz
  3.015  TARGET       -p
  3.016  DISP         Set the UUT to 10 dB.
  3.017  9640         +Freq = 1500 MHz; Level = 5 dBm; OutputImp = 50 Ohms
  3.018  TARGET       -m
  3.019  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
  3.019  N5531        +RelLevel = -10.00 dB; Read
  3.020  MEMC   100   -10.00dB       0.2U          1500MHz

  4.001  HEAD         -2 20 dB @ 1500 MHz
  4.002  TARGET       -p
  4.003  DISP         Set the UUT to 20 dB.
  4.004  9640         +Freq = 1500 MHz; Level = 5 dBm; OutputImp = 50 Ohms
  4.005  TARGET       -m
  4.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
  4.006  N5531        +RelLevel = -20.00 dB; Read
  4.007  MEMC   100   -20.00dB       0.4U          1500MHz

  5.001  HEAD         -2 30 dB @ 1500 MHz
  5.002  TARGET       -p
  5.003  DISP         Set the UUT to 30 dB.
  5.004  9640         +Freq = 1500 MHz; Level = 5 dBm; OutputImp = 50 Ohms
  5.005  TARGET       -m
  5.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
  5.006  N5531        +RelLevel = -30.00 dB; Read
  5.007  MEMC   100   -30.00dB       0.5U          1500MHz

  6.001  HEAD         -2 40 dB @ 1500 MHz
  6.002  TARGET       -p
  6.003  DISP         Set the UUT to 40 dB.
  6.004  9640         +Freq = 1500 MHz; Level = 5 dBm; OutputImp = 50 Ohms
  6.005  TARGET       -m
  6.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
  6.006  N5531        +RelLevel = -40.00 dB; Read
  6.007  MEMC   100   -40.00dB       0.7U          1500MHz

  7.001  HEAD         -2 50 dB @ 1500 MHz
  7.002  TARGET       -p
  7.003  DISP         Set the UUT to 50 dB.
  7.004  9640         +Freq = 1500 MHz; Level = 5 dBm; OutputImp = 50 Ohms
  7.005  TARGET       -m
  7.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
  7.006  N5531        +RelLevel = -50.00 dB; Read
  7.007  MEMC   100   -50.00dB       0.8U          1500MHz

  8.001  HEAD         -2 60 dB @ 1500 MHz
  8.002  TARGET       -p
  8.003  DISP         Set the UUT to 60 dB.
  8.004  9640         +Freq = 1500 MHz; Level = 5 dBm; OutputImp = 50 Ohms
  8.005  TARGET       -m
  8.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
  8.006  N5531        +RelLevel = -60.00 dB; Read
  8.007  MEMC   100   -60.00dB       1.0U          1500MHz

  9.001  HEAD         -2 70 dB @ 1500 MHz
  9.002  TARGET       -p
  9.003  DISP         Set the UUT to 70 dB.
  9.004  9640         +Freq = 1500 MHz; Level = 5 dBm; OutputImp = 50 Ohms
  9.005  TARGET       -m
  9.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
  9.006  N5531        +RelLevel = -70.00 dB; Read
  9.007  MEMC   100   -70.00dB       1.2U          1500MHz

 10.001  HEAD         -2 80 dB @ 1500 MHz
 10.002  TARGET       -p
 10.003  DISP         Set the UUT to 80 dB.
 10.004  9640         +Freq = 1500 MHz; Level = 5 dBm; OutputImp = 50 Ohms
 10.005  TARGET       -m
 10.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
 10.006  N5531        +RelLevel = -80.00 dB; Read
 10.007  MEMC   100   -80.00dB       1.3U          1500MHz

 11.001  HEAD         -2 90 dB @ 1500 MHz
 11.002  TARGET       -p
 11.003  DISP         Set the UUT to 90 dB.
 11.004  9640         +Freq = 1500 MHz; Level = 5 dBm; OutputImp = 50 Ohms
 11.005  TARGET       -m
 11.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
 11.006  N5531        +RelLevel = -90.00 dB; Read
 11.007  MEMC   100   -90.00dB       1.5U          1500MHz

 12.001  HEAD         -2 100 dB @ 1500 MHz
 12.002  TARGET       -p
 12.003  DISP         Set the UUT to 100 dB.
 12.004  9640         +Freq = 1500 MHz; Level = 5 dBm; OutputImp = 50 Ohms
 12.005  TARGET       -m
 12.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
 12.006  N5531        +RelLevel = -100.00 dB; Read
 12.007  MEMC   100   -100.00dB      1.6U          1500MHz

 13.001  HEAD         -2 110 dB @ 1500 MHz
 13.002  TARGET       -p
 13.003  DISP         Set the UUT to 110 dB.
 13.004  9640         +Freq = 1500 MHz; Level = 5 dBm; OutputImp = 50 Ohms
 13.005  TARGET       -m
 13.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
 13.006  N5531        +RelLevel = -110.00 dB; Read
 13.007  MEMC   100   -110.00dB      1.8U          1500MHz

 14.001  9640         Standby

 14.002  HEAD         ATTENUATION
 14.003  HEAD         -2 SET 0 dB REFERENCE @ 4000 MHz
 14.004  RSLT         =
 14.005  RSLT         = 4000 MHz
 14.006  TARGET       -p
 14.007  DISP         Set the UUT to 0 dB.
 14.008  9640         +Freq = 4000 MHz; Level = 5 dBm; OutputImp = 50 Ohms
 14.009  N5531        InputAttenuation = 10 dB
 14.009  N5531        +Freq = 4000 MHz; Power = 5 dBm
 14.010  MATH         FreqMHz = MEM
 14.011  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
 14.011  N5531        +Level = -15 dBm; SetRef

 14.012  HEAD         -2 10 dB @ 4000 MHz
 14.013  DISP         Set the UUT to 10 dB.
 14.014  9640         +Freq = 4000 MHz; Level = 5 dBm; OutputImp = 50 Ohms
 14.015  TARGET       -m
 14.016  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
 14.016  N5531        +RelLevel = -10.00 dB; Read
 14.017  MEMC   100   -10.00dB       0.2U          4000MHz

 15.001  HEAD         -2 20 dB @ 4000 MHz
 15.002  TARGET       -p
 15.003  DISP         Set the UUT to 20 dB.
 15.004  9640         +Freq = 4000 MHz; Level = 5 dBm; OutputImp = 50 Ohms
 15.005  TARGET       -m
 15.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
 15.006  N5531        +RelLevel = -20.00 dB; Read
 15.007  MEMC   100   -20.00dB       0.4U          4000MHz

 16.001  HEAD         -2 30 dB @ 4000 MHz
 16.002  TARGET       -p
 16.003  DISP         Set the UUT to 30 dB.
 16.004  9640         +Freq = 4000 MHz; Level = 5 dBm; OutputImp = 50 Ohms
 16.005  TARGET       -m
 16.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
 16.006  N5531        +RelLevel = -30.00 dB; Read
 16.007  MEMC   100   -30.00dB       0.5U          4000MHz

 17.001  HEAD         -2 40 dB @ 4000 MHz
 17.002  TARGET       -p
 17.003  DISP         Set the UUT to 40 dB.
 17.004  9640         +Freq = 4000 MHz; Level = 5 dBm; OutputImp = 50 Ohms
 17.005  TARGET       -m
 17.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
 17.006  N5531        +RelLevel = -40.00 dB; Read
 17.007  MEMC   100   -40.00dB       0.7U          4000MHz

 18.001  HEAD         -2 50 dB @ 4000 MHz
 18.002  TARGET       -p
 18.003  DISP         Set the UUT to 50 dB.
 18.004  9640         +Freq = 4000 MHz; Level = 5 dBm; OutputImp = 50 Ohms
 18.005  TARGET       -m
 18.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
 18.006  N5531        +RelLevel = -50.00 dB; Read
 18.007  MEMC   100   -50.00dB       0.8U          4000MHz

 19.001  HEAD         -2 60 dB @ 4000 MHz
 19.002  TARGET       -p
 19.003  DISP         Set the UUT to 60 dB.
 19.004  9640         +Freq = 4000 MHz; Level = 5 dBm; OutputImp = 50 Ohms
 19.005  TARGET       -m
 19.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
 19.006  N5531        +RelLevel = -60.00 dB; Read
 19.007  MEMC   100   -60.00dB       1.0U          4000MHz

 20.001  HEAD         -2 70 dB @ 4000 MHz
 20.002  TARGET       -p
 20.003  DISP         Set the UUT to 70 dB.
 20.004  9640         +Freq = 4000 MHz; Level = 5 dBm; OutputImp = 50 Ohms
 20.005  TARGET       -m
 20.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
 20.006  N5531        +RelLevel = -70.00 dB; Read
 20.007  MEMC   100   -70.00dB       1.2U          4000MHz

 21.001  HEAD         -2 80 dB @ 4000 MHz
 21.002  TARGET       -p
 21.003  DISP         Set the UUT to 80 dB.
 21.004  9640         +Freq = 4000 MHz; Level = 5 dBm; OutputImp = 50 Ohms
 21.005  TARGET       -m
 21.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
 21.006  N5531        +RelLevel = -80.00 dB; Read
 21.007  MEMC   100   -80.00dB       1.3U          4000MHz

 22.001  HEAD         -2 90 dB @ 4000 MHz
 22.002  TARGET       -p
 22.003  DISP         Set the UUT to 90 dB.
 22.004  9640         +Freq = 4000 MHz; Level = 5 dBm; OutputImp = 50 Ohms
 22.005  TARGET       -m
 22.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
 22.006  N5531        +RelLevel = -90.00 dB; Read
 22.007  MEMC   100   -90.00dB       1.5U          4000MHz

 23.001  HEAD         -2 100 dB @ 4000 MHz
 23.002  TARGET       -p
 23.003  DISP         Set the UUT to 100 dB.
 23.004  9640         +Freq = 4000 MHz; Level = 5 dBm; OutputImp = 50 Ohms
 23.005  TARGET       -m
 23.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
 23.006  N5531        +RelLevel = -100.00 dB; Read
 23.007  MEMC   100   -100.00dB      1.6U          4000MHz

 24.001  HEAD         -2 110 dB @ 4000 MHz
 24.002  TARGET       -p
 24.003  DISP         Set the UUT to 110 dB.
 24.004  9640         +Freq = 4000 MHz; Level = 5 dBm; OutputImp = 50 Ohms
 24.005  TARGET       -m
 24.006  N5531        Freq = [V FreqMHz] MHz; InputAttenuation = 10 dB
 24.006  N5531        +RelLevel = -110.00 dB; Read
 24.007  MEMC   100   -110.00dB      1.8U          4000MHz

 25.001  HEAD
 25.002  HEAD         -2
 25.003  END
